#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using System.Text.RegularExpressions;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.Common;

#endregion

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// BloodUnitSelectorVertical
	/// </summary>
	public class BloodUnitSelectorVertical : GUI.controls.BaseControl
	{
		#region Variables

		private BloodUnit _selectedBloodUnit;
		
		private AdditionalBloodUnitSearchCriteria _searchCriteria = Common.AdditionalBloodUnitSearchCriteria.UnitsInFinalStatus;
		//
		private Regex _isbtUnitID;
		private Regex _isbtProductCode;
		private Regex _codabarUnitID;
		private Regex _codabarProductCode;

		#endregion

		#region Delegates
		
		private event EventHandler onSearchBtnClick;
		private event EventHandler onClearBtnClick;
		private event EventHandler onUnitUpdated;	

		#endregion

		#region Controls

		private gov.va.med.vbecs.GUI.controls.VbecsErrorProvider errorProvider1; // **** 508 Compliance ***
		private gov.va.med.vbecs.GUI.controls.BloodUnitLabel bloodUnitLabel1;
		private System.Windows.Forms.GroupBox grpSearch;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.Windows.Forms.PictureBox pictureBox4;
		private System.Windows.Forms.Label lblUnitID;
		private System.Windows.Forms.Label lblProduct;
		private System.Windows.Forms.Button btnClear;
		private System.Windows.Forms.Button btnSearch;
		private System.ComponentModel.IContainer components;

		/// <summary>
		/// txtProductID
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.ProductCodeTextbox txtProductID;

		/// <summary>
		/// txtUnitID
		/// </summary>
		public gov.va.med.vbecs.GUI.controls.UnitIDTextbox txtUnitID;

		#endregion

		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public BloodUnitSelectorVertical()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();
			//
			this._codabarProductCode = Common.RegularExpressions.CodabarProductCode();
			this._codabarUnitID = Common.RegularExpressions.PooledCodabarEyeReadableUnitId();
			this._isbtProductCode = Common.RegularExpressions.ISBT128ProductCode();
			this._isbtUnitID = Common.RegularExpressions.ISBT128UnitID();
			//
			// Default to false, client can change property if functionality is req'd
			this._searchCriteria = Common.AdditionalBloodUnitSearchCriteria.None;

			this.errorProvider1.SetIconAlignment(this.txtUnitID, ErrorIconAlignment.MiddleLeft);
			this.errorProvider1.SetIconAlignment(this.txtProductID, ErrorIconAlignment.MiddleLeft);
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Component Designer generated code

		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(BloodUnitSelectorVertical));
			this.errorProvider1 = new gov.va.med.vbecs.GUI.controls.VbecsErrorProvider();
			this.bloodUnitLabel1 = new gov.va.med.vbecs.GUI.controls.BloodUnitLabel(this.components);
			this.grpSearch = new System.Windows.Forms.GroupBox();
			this.btnClear = new System.Windows.Forms.Button();
			this.txtProductID = new gov.va.med.vbecs.GUI.controls.ProductCodeTextbox(this.components);
			this.txtUnitID = new gov.va.med.vbecs.GUI.controls.UnitIDTextbox(this.components);
			this.btnSearch = new System.Windows.Forms.Button();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.pictureBox4 = new System.Windows.Forms.PictureBox();
			this.lblUnitID = new System.Windows.Forms.Label();
			this.lblProduct = new System.Windows.Forms.Label();
			this.grpSearch.SuspendLayout();
			this.SuspendLayout();
			// 
			// errorProvider1
			// 
			this.errorProvider1.ContainerControl = this;
			this.errorProvider1.DataMember = "";
			this.errorProvider1.Icon = ((System.Drawing.Icon)(resources.GetObject("errorProvider1.Icon")));
			// 
			// bloodUnitLabel1
			// 
			this.bloodUnitLabel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.bloodUnitLabel1.BackColor = System.Drawing.Color.White;
			this.bloodUnitLabel1.BloodUnit = null;
			this.bloodUnitLabel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitLabel1.Location = new System.Drawing.Point(0, 100);
			this.bloodUnitLabel1.Name = "bloodUnitLabel1";
			this.bloodUnitLabel1.Size = new System.Drawing.Size(257, 204);
			this.bloodUnitLabel1.TabIndex = 5;
			this.bloodUnitLabel1.TabStop = false;
			// 
			// grpSearch
			// 
			this.grpSearch.AccessibleDescription = "Unit Search";
			this.grpSearch.AccessibleName = "Unit Search";
			this.grpSearch.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpSearch.Controls.Add(this.btnClear);
			this.grpSearch.Controls.Add(this.txtProductID);
			this.grpSearch.Controls.Add(this.txtUnitID);
			this.grpSearch.Controls.Add(this.btnSearch);
			this.grpSearch.Controls.Add(this.pictureBox2);
			this.grpSearch.Controls.Add(this.pictureBox4);
			this.grpSearch.Controls.Add(this.lblUnitID);
			this.grpSearch.Controls.Add(this.lblProduct);
			this.grpSearch.Location = new System.Drawing.Point(0, 0);
			this.grpSearch.Name = "grpSearch";
			this.grpSearch.Size = new System.Drawing.Size(258, 96);
			this.grpSearch.TabIndex = 0;
			this.grpSearch.TabStop = false;
			this.grpSearch.Text = "Unit Search";
			// 
			// btnClear
			// 
			this.btnClear.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnClear.Location = new System.Drawing.Point(156, 68);
			this.btnClear.Name = "btnClear";
			this.btnClear.TabIndex = 4;
			this.btnClear.Text = "C&lear";
			this.btnClear.Click += new System.EventHandler(this.OnClearBtnClick);
			// 
			// txtProductID
			// 
			this.txtProductID.AccessibleDescription = "Product";
			this.txtProductID.AccessibleName = "Product";
			this.txtProductID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtProductID.Barcode = false;
			this.txtProductID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtProductID.Location = new System.Drawing.Point(88, 44);
			this.txtProductID.MaxLength = 10;
			this.txtProductID.Name = "txtProductID";
			this.txtProductID.RecursionGuard = false;
			this.txtProductID.Size = new System.Drawing.Size(142, 20);
			this.txtProductID.TabIndex = 2;
			this.txtProductID.Text = "";
			this.txtProductID.KeyDown += new System.Windows.Forms.KeyEventHandler(this.SearchKeyDown);
			this.txtProductID.Leave += new System.EventHandler(this.SearchLeave);
			// 
			// txtUnitID
			// 
			this.txtUnitID.AccessibleDescription = "Unit I D";
			this.txtUnitID.AccessibleName = "Unit I D";
			this.txtUnitID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtUnitID.Barcode = false;
			this.txtUnitID.BarcodeType = gov.va.med.vbecs.Common.BarcodeType.None;
			this.txtUnitID.Location = new System.Drawing.Point(88, 20);
			this.txtUnitID.MaxLength = 15;
			this.txtUnitID.Name = "txtUnitID";
			this.txtUnitID.Size = new System.Drawing.Size(142, 20);
			this.txtUnitID.TabIndex = 1;
			this.txtUnitID.Text = "";
			this.txtUnitID.KeyDown += new System.Windows.Forms.KeyEventHandler(this.SearchKeyDown);
			this.txtUnitID.Leave += new System.EventHandler(this.SearchLeave);
			// 
			// btnSearch
			// 
			this.btnSearch.AccessibleDescription = "Find";
			this.btnSearch.AccessibleName = "Find";
			this.btnSearch.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.btnSearch.Font = new System.Drawing.Font("Arial", 5.25F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnSearch.Location = new System.Drawing.Point(230, 20);
			this.btnSearch.Name = "btnSearch";
			this.btnSearch.Size = new System.Drawing.Size(26, 20);
			this.btnSearch.TabIndex = 3;
			this.btnSearch.Text = "find";
			this.btnSearch.Click += new System.EventHandler(this.OnSearchBtnClick);
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(8, 20);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(20, 20);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox2.TabIndex = 18;
			this.pictureBox2.TabStop = false;
			// 
			// pictureBox4
			// 
			this.pictureBox4.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox4.Image")));
			this.pictureBox4.Location = new System.Drawing.Point(8, 44);
			this.pictureBox4.Name = "pictureBox4";
			this.pictureBox4.Size = new System.Drawing.Size(20, 20);
			this.pictureBox4.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox4.TabIndex = 16;
			this.pictureBox4.TabStop = false;
			// 
			// lblUnitID
			// 
			this.lblUnitID.Location = new System.Drawing.Point(28, 20);
			this.lblUnitID.Name = "lblUnitID";
			this.lblUnitID.Size = new System.Drawing.Size(56, 20);
			this.lblUnitID.TabIndex = 0;
			this.lblUnitID.Text = "Unit ID*";
			this.lblUnitID.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblProduct
			// 
			this.lblProduct.Location = new System.Drawing.Point(28, 44);
			this.lblProduct.Name = "lblProduct";
			this.lblProduct.Size = new System.Drawing.Size(56, 20);
			this.lblProduct.TabIndex = 2;
			this.lblProduct.Text = "Product*";
			this.lblProduct.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// BloodUnitSelectorVertical
			// 
			this.Controls.Add(this.grpSearch);
			this.Controls.Add(this.bloodUnitLabel1);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "BloodUnitSelectorVertical";
			this.Size = new System.Drawing.Size(258, 304);
			this.grpSearch.ResumeLayout(false);
			this.ResumeLayout(false);

		}

		#endregion

		#region Properties

		///<Developers>
		///	<Developer>David Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/20/2004</CreationDate>
		/// <summary>
		/// Used to return units that meet additional
		/// criteria.  For example, also bring 
		/// back units in final status.  
		/// </summary>
		public AdditionalBloodUnitSearchCriteria AdditionalSearchCriteria
		{
			get
			{
				return(this._searchCriteria);
			}
			set
			{
				this._searchCriteria = value;
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/4/2004</CreationDate>
		/// <summary>
		/// Returns the eye readable unit id entered in the textbox field
		/// </summary>
		public string EnteredEyeReadableUnitId
		{
			get
			{
				return(this.txtUnitID.Text.Trim());
			}
		}

		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/4/2004</CreationDate>
		/// <summary>
		/// Returns the unit product code enetered in the textbox field - used to filter the UC5 list
		/// </summary>
		public string EnteredUnitProductCode
		{
			get
			{
				return(this.txtProductID.Text.Trim());
			}
		}

		/// <summary>
		/// The current unit the user is working with
		/// </summary>
		public BOL.BloodUnit SelectedBloodUnit
		{
			get
			{
				return this._selectedBloodUnit;
			}
		}

		#endregion

		#region Events

		/// <summary>
		/// Event to fire when the user clicks the elipse button to search for a unit
		/// </summary>
		public event EventHandler SearchBtnClick
		{
			add
			{
				onSearchBtnClick += value;
			}
			remove
			{
				onSearchBtnClick -= value;
			}
		}

		private void OnSearchBtnClick(object sender, EventArgs e)
		{
			if (onSearchBtnClick != null)
			{
				onSearchBtnClick(this,e);
			}
		}

		/// <summary>
		/// Event to attach to the "Clear" button_Click event
		/// </summary>
		public event EventHandler ClearBtnClick
		{
			add
			{
				onClearBtnClick += value;
			}
			remove
			{
				onClearBtnClick -= value;
			}
		}

		private void OnClearBtnClick(object sender, EventArgs e)
		{
			this.OnUserActivity();

			this.txtProductID.Text = "";
			this.txtUnitID.Text = "";
			this.bloodUnitLabel1.BloodUnit = null;
			this._selectedBloodUnit = null;
			this.errorProvider1.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
			this.errorProvider1.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
			//
			if (onClearBtnClick != null)
			{
				onClearBtnClick(sender,e);
			}
			//
			this.txtUnitID.Focus();
		}

		/// <summary>
		/// Set to fire if the user enters a valid bloodunit
		/// </summary>
		public event EventHandler UnitUpdated
		{
			add
			{
				onUnitUpdated += value;
			}
			remove
			{
				onUnitUpdated -= value;
			}
		}

		private void OnUnitUpdated(object sender, EventArgs e)
		{
			if (onUnitUpdated != null)
			{
				onUnitUpdated(this,e);
			}
		}

		#endregion

		#region Methods

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/26/2005</CreationDate>
		///
		/// <summary>
		/// ClearControlData : allows form to Dispose (hopefully!)
		/// </summary>
		public void ClearControlData()
		{
			this.txtProductID.Parent = null;
			this.txtProductID.Dispose();
			//
			this.txtUnitID.Parent = null;
			this.txtUnitID.Dispose();
			//
			if (this._selectedBloodUnit != null) { this._selectedBloodUnit.Dispose(); }
			//
			if (this.bloodUnitLabel1 != null) 
			{
				if(this.bloodUnitLabel1.BloodUnit != null)
				{
					this.bloodUnitLabel1.BloodUnit.Dispose();
				}
				this.bloodUnitLabel1.Parent = null;
				this.bloodUnitLabel1.Dispose();
			}
			//
			this.errorProvider1.Dispose();
			// 
			this.btnClear.Parent = null;
			this.btnClear.Dispose();
			//
			this.btnSearch.Parent = null;
			this.btnSearch.Dispose();
			//
			this.grpSearch.Parent = null;
			this.grpSearch.Dispose();
			//
			this.lblProduct.Parent = null;
			this.lblProduct.Dispose();
			//
			this.lblUnitID.Parent = null;
			this.lblUnitID.Dispose();
			//
			this.pictureBox2.Parent = null;
			this.pictureBox2.Dispose();
			//
			this.pictureBox4.Parent = null;
			this.pictureBox4.Dispose();
			//
			this.txtProductID.Parent = null;
			this.txtProductID.Dispose();
			// 
			this.txtUnitID.Parent = null;
			this.txtUnitID.Dispose();
		}

		///<Developers>
		///	<Developer>D. Askew</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/26/2005</CreationDate>
		/// <summary>
		/// ClearBloodUnit
		/// </summary>
		public void ClearBloodUnit()
		{
			this.txtProductID.Text = "";
			this.txtUnitID.Text = "";
			//
			if(this._selectedBloodUnit != null)
			{
				this._selectedBloodUnit.Dispose();
				this._selectedBloodUnit = null;
			}
			if(this.bloodUnitLabel1.BloodUnit != null)
			{
				this.bloodUnitLabel1.BloodUnit.Dispose();
				this.bloodUnitLabel1.BloodUnit = null;
			}
			//
			this.errorProvider1.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
			this.errorProvider1.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
			this.txtUnitID.Focus();
		}

		/// <summary>
		/// DisplayBloodUnit
		/// </summary>
		private void DisplayBloodUnit()
		{
			this.OnUserActivity();
			this.bloodUnitLabel1.BloodUnit = this._selectedBloodUnit;
			//
			if (this._selectedBloodUnit != null)
			{
				if (this.txtUnitID.Text != this._selectedBloodUnit.EyeReadableUnitId)
				{
					this.txtUnitID.Text = this._selectedBloodUnit.EyeReadableUnitId;
				}
				//
				if (this.txtProductID.Text != this._selectedBloodUnit.FullProductCode)
				{
					this.txtProductID.Text = this._selectedBloodUnit.FullProductCode;
				}
			}
		}

		/// <summary>
		/// FindBloodUnit
		/// </summary>
		private void FindBloodUnit()
		{
			bool errOnUnit = true;

			try
			{
				//Reset the flags JIC
				this.errorProvider1.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
				this.errorProvider1.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***

				System.Guid bloodUnitGuid = Guid.Empty;
				DataTable selectedBloodUnitsTable;
				//
				if (this.txtUnitID.Text.Trim().Length == 0 && this.txtProductID.Text.Trim().Length == 0)
				{
					this._selectedBloodUnit = null;
					this.DisplayBloodUnit();
					return;
				}

				if (this.txtUnitID.Text.Length == 0) return;
				if (!this._codabarUnitID.IsMatch(this.txtUnitID.Text) && !this._isbtUnitID.IsMatch(this.txtUnitID.Text))
				{
					throw new BOL.BusinessObjectException("Unrecognized Unit Id format");
				}

				if (this.txtProductID.Text.Length == 0) return;
				if (!this._codabarProductCode.IsMatch(this.txtProductID.Text) && !this._isbtProductCode.IsMatch(this.txtProductID.Text))
				{
					errOnUnit = false;
					throw new BOL.BusinessObjectException("Unrecognized Product Code format");
				}

				selectedBloodUnitsTable = BOL.BloodUnit.GetBloodUnitsByIdAndProduct(this.txtUnitID.Text.Trim(), this.txtProductID.Text.Substring(0,5), Common.LogonUser.LogonUserDivisionCode, BOL.BloodUnit.GetUnitDivisionId(this.txtProductID.Text), BOL.BloodUnit.GetDonationTypeCode(this.txtProductID.Text), this.AdditionalSearchCriteria);
                //CR3294 - GetBloodUnitsByIdAndProduct() no longer throwing exception when Rows.Count = 0
                if (selectedBloodUnitsTable.Rows.Count == 0)
                {
                    throw new BOL.BusinessObjectException("BloodUnit not found for UnitId/Product Code");
                }
                //
				if(selectedBloodUnitsTable.Rows.Count > 1)
				{ 
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(selectedBloodUnitsTable, this.EnteredEyeReadableUnitId, this.EnteredUnitProductCode);
					unitSelector.MultiSelect = false;
					unitSelector.TitleBarText = "VBECS - Multiple Units Per Product Code - Please Select Unit";
					unitSelector.LogoBarText = "Select Unit";
					unitSelector.ShowDialog(this.FindForm());
					//
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						bloodUnitGuid = (Guid)unitSelector.SelectedUnits.Rows[0][Common.VbecsTables.BloodUnit.BloodUnitGuid];
						if(unitSelector.SelectedUnits.Rows[0][Common.VbecsTables.BloodUnit.RecordStatusCode].ToString().Equals(Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive).ToString()))
						{
							Common.Utility.MessageBeep();
						}
					}
					else if(unitSelector.DialogResult == DialogResult.Cancel)
					{
						// user has cancelled so call clear event and return
						OnClearBtnClick(null, EventArgs.Empty);
						return;
					}
				}
				else
				{
					bloodUnitGuid = (Guid)selectedBloodUnitsTable.Rows[0][Common.VbecsTables.BloodUnit.BloodUnitGuid];
					if(selectedBloodUnitsTable.Rows[0][Common.VbecsTables.BloodUnit.RecordStatusCode].ToString().Equals(Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Inactive).ToString()))
					{
						Common.Utility.MessageBeep();
					}
				}

				this._selectedBloodUnit = new BOL.BloodUnit(bloodUnitGuid);
				this.DisplayBloodUnit();
				OnUnitUpdated(null, EventArgs.Empty);
				//
				this.errorProvider1.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
				this.errorProvider1.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
				
			}
			catch(Exception err)
			{
				this._selectedBloodUnit = null;
				
				if (errOnUnit)
					this.errorProvider1.SetVbecsError(this.txtUnitID, err.Message); // **** 508 Compliance ***
				else
					this.errorProvider1.SetVbecsError(this.txtProductID, err.Message); // **** 508 Compliance ***

				this.DisplayBloodUnit();
			}
		}

		/// <summary>
		/// /// Populate the BloodBag label and BloodUnit Details tab
		/// </summary>
		/// <param name="unitID"></param>
		/// <param name="fullProductCode"></param>
		public void DisplayBloodUnit(string unitID, string fullProductCode)
		{
			this.txtUnitID.Text = unitID;

			if ((fullProductCode.Trim().Length == 8) || (fullProductCode.Trim().Length == 0))
			{
				txtProductID.Text = fullProductCode;
			}
			else
			{
				txtProductID.Text = fullProductCode.Substring(0,5);
			}

			this.errorProvider1.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
			this.errorProvider1.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
			//
			FindBloodUnit();
		}

		/// <summary>
		/// Populate the BloodBag label and BloodUnit Details tab
		/// </summary>
		/// <param name="bloodUnit"></param>
		public void DisplayBloodUnit(BOL.BloodUnit bloodUnit)
		{
			this._selectedBloodUnit = bloodUnit;
			//
			this.txtUnitID.Text = this._selectedBloodUnit.EyeReadableUnitId;
			this.txtProductID.Text = this._selectedBloodUnit.ProductCode;
			//
			this.errorProvider1.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
			this.errorProvider1.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
			//
			this.DisplayBloodUnit();
			OnUnitUpdated(null, EventArgs.Empty);
			//
			this.errorProvider1.SetVbecsError(this.txtProductID, string.Empty); // **** 508 Compliance ***
			this.errorProvider1.SetVbecsError(this.txtUnitID, string.Empty); // **** 508 Compliance ***
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// Get the error messages active for the control
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessages()
		{
			return this.errorProvider1.GetErrorMessages();
		}

		#endregion

		#region Control events

		/// <summary>
		/// Handles KeyDown events for txtUnitID and txtProductID
		/// </summary>
		private void SearchKeyDown(object sender, System.Windows.Forms.KeyEventArgs e)
		{
			this.OnUserActivity();

			if (this._selectedBloodUnit == null && !this.txtUnitID.ReadOnly)
			{
				if (e.KeyCode == Keys.Enter)
				{
					//Pretend ENTER is a tab
					this.SelectNextControl((TextBox)sender,true,true,true,true);
				}
			}
		}

		/// <summary>
		/// Handles Leave events for txtUnitID and txtProductID
		/// </summary>
		private void SearchLeave(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (this._selectedBloodUnit == null && !this.txtUnitID.ReadOnly)
			{
				FindBloodUnit();
			}
		}

		#endregion
	}
}
